////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////                                                                        ////
////     01010101   010        010   0101010101   0101010101      0110      ////
////    01      01  01010    10101   01           01             01  10     ////
////   01        01 01 010  101 01   01           01             01  10     ////
////   01        01 01  010010  01   0101010101   01            01    10    ////
////    01      01  01    00    01   01           01    0101    01010110    ////
////     01    01   01          01   01           01      01   01      10   ////
////   0101    0101 01          01   0101010101   0101010101   01      10   ////
////                                                                        ////
////                        0101010101 01010101                             ////
////                                01 01      01                           ////
////                                01 01      01                           ////
////                          01010101 01      01                           ////
////                                01 01      01                           ////
////                                01 01      01                           ////
////                        0101010101 01010101                             ////
////                                                                        ////
////       : 0.63                                                     ////
////         : 21.08.07                                                 ////
////   e: http://www.isada.mirgames.ru/omega3d.htm                 ////
////                                                                        ////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////                                                                        ////
////  : Andru 'aka'                                         ////
////  Mail: dr.andru@gmail.com                                              ////
////  Site: http://isada.mirgames.ru                                        ////
////                                                                        ////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////                                                                        ////
////                                    :             ////
////                                                                        ////
////          OMEGA Engine.   ////
////                                                                        ////
////                                                             ()2007    ////
////                                                                        ////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
unit OMEGA3D;
interface   
uses OMEGA;

var
  LibOmega3D : HMODULE;

procedure LoadOMEGA3D( FileName : String );
procedure FreeOMEGA3D;

// G L O B A L  T Y P E S
type
  PVertex2D = ^TVertex2D;
  TVertex2D = record
    X, Y : Single;
end;

type
  PVertex3D = ^TVertex3D;
  TVertex3D = record
    X, Y, Z : Single;
end;

type
  PFrustum = ^TFrustum;
  TFrustum = array [ 0..5 ] of array[ 0..3 ] of Single;

type
  PMatrix4f = ^TMatrix4f;
  TMatrix4f = array[ 0..3, 0..3 ] of Single;
{------------------------------------------------------------------------------}
{--------------------------------  M A I N  -----------------------------------}
{------------------------------------------------------------------------------}

var
OE3D_Init : procedure; stdcall;

Set2DMode : procedure; stdcall;
Set3DMode : procedure( FOVY : Single = 45.0 ); stdcall;

{------------------------------------------------------------------------------}
{-----------------------------  Z B U F F E R  --------------------------------}
{------------------------------------------------------------------------------}

ZBuffer_Clear : procedure; stdcall;
ZBuffer_SetDepth : procedure( z_Near, z_Far : Single ); stdcall;
ZBuffer_SetActive : procedure( Enable : Boolean ); stdcall;

{------------------------------------------------------------------------------}
{----------------------------  3 D  O B J E C T S  ----------------------------}
{------------------------------------------------------------------------------}

// FLAGS
const
  OF_TEXTURING    = $000001;
  OF_MTEXTURING   = $000002;

  OF_BLEND        = $000004;
  OF_ALPHA_TEST   = $000008;

  OF_LIGHTING     = $000010;

  OF_CULL_FACE    = $000020;

  OF_WIRE_FRAME   = $000040;

  OF_SPHERE_MAP_S = $000080;
  OF_SPHERE_MAP_T = $000100;

var
// INIT
Obj_Begin : procedure( Flags : Integer ); stdcall;
Obj_End : procedure; stdcall;

// OPTIONS
Obj_Enable : procedure( Flags : Integer ); stdcall;
Obj_Disable : procedure( Flags : Integer ); stdcall;

const
  CFM_FRONT = 0;
  CFM_BACK  = 1;
var
Obj_SetCullFaceMode : procedure( Mode : Byte ); stdcall;

const
  SM_FLAT   = 0;
  SM_SMOOTH = 1;
var
Obj_SetShadeMode : procedure( Mode : Byte ); stdcall;

const
  WFM_FRONT          = 0;
  WFM_BACK           = 1;
  WFM_FRONT_AND_BACK = 2;
var
Obj_SetWireFrameMode : procedure( Mode : Byte ); stdcall;

// TRANSFORM
Obj_PushMatrix : procedure; stdcall;
Obj_PopMatrix : procedure; stdcall;
Obj_ClearMatrix : procedure; stdcall;

Obj_Move : procedure( X, Y, Z : Single ); stdcall;
Obj_Move2D : procedure( X, Y : Integer; Z : Single = 1 ); stdcall;

Obj_RotateX : procedure( Angle : Single ); stdcall;
Obj_RotateY : procedure( Angle : Single ); stdcall;
Obj_RotateZ : procedure( Angle : Single ); stdcall;

Obj_Scale : procedure( X, Y, Z : Single ); stdcall;

Obj_Get3D : function( X, Y : Integer ) : TVertex3D; stdcall;
Obj_Get2D : function( X, Y, Z : Single ) : oePoint; stdcall;

// MATERIAL
Obj_BindTexture : procedure( TextureID : PTexture ); stdcall;
Obj_BindMTexture : procedure( TextureID : PTexture; Layer : Byte ); stdcall;

Obj_SetColor : procedure( Color : Integer;
                          Alpha : Integer = 255 ); stdcall;

const
  MAT_AMBIENT   = 0;
  MAT_DIFFUSE   = 1;
  MAT_SPECULAR  = 2;
  MAT_EMISSION  = 3;
  MAT_SHININESS = 4;

  SIDE_FRONT          = 0;
  SIDE_BACK           = 1;
  SIDE_FRONT_AND_BACK = 2;
var
Obj_SetMaterial : procedure( MType, Side : Byte;
                             Color       : Integer;
                             Alpha       : Integer = 255 ); stdcall;

Obj_ResetMaterial : procedure; stdcall;

{------------------------------------------------------------------------------}
{---------------------------  C A M E R A  3 D  -------------------------------}
{------------------------------------------------------------------------------}

type
  PCamera3D = ^TCamera3D;
  TCamera3D = record
    Eyes     : TVertex3D;
    Center   : TVertex3D;
    Reserved : DWORD;
end;

var
Cam3D_Create : function : PCamera3D; stdcall;
Cam3D_Free : procedure( var YourCamera : PCamera3D ); stdcall;

Cam3D_Set : procedure( YourCamera : PCamera3D ); stdcall;

Cam3D_RotateRad : procedure( Camera : PCamera3D; X, Y, Z : Single ); stdcall;
Cam3D_RotateAng : procedure( Camera : PCamera3D; X, Y, Z : Integer ); stdcall;

Cam3D_Fly : procedure( Camera : PCamera3D; Speed : Single ); stdcall;
Cam3D_Strafe : procedure( Camera : PCamera3D; Speed : Single ); stdcall;

{------------------------------------------------------------------------------}
{------------------------------  E F F E C T S  -------------------------------}
{------------------------------------------------------------------------------}
// FOG
Fog_Enable : procedure; stdcall;
Fog_Disable : procedure; stdcall;

const
  FOG_MODE_EXP1   = 0;
  FOG_MODE_EXP2   = 1;
  FOG_MODE_LINEAR = 2;
var
Fog_SetMode : procedure( Mode : Byte ) ; stdcall;

Fog_SetColor : procedure( Color : Integer ); stdcall;

Fog_SetDensity : procedure( Distance : Single ); stdcall;
Fog_SetBeginEnd : procedure( fBegin, fEnd : Single ); stdcall;

// LIGHT
const
  LIGHT_1 = 1;
  LIGHT_2 = 2;
  LIGHT_3 = 3;
  LIGHT_4 = 4;
  LIGHT_5 = 5;
  LIGHT_6 = 6;
  LIGHT_7 = 7;
  LIGHT_8 = 8;
var
Light_Enable : procedure( ID : Byte ); stdcall;
Light_Disable : procedure( ID : Byte ); stdcall;

Light_GetMaxID : function : Byte; stdcall;

Light_SetPosition : procedure( ID : Byte; X, Y, Z : Single; W : Single = 0 ); stdcall;

Light_SetMaterial : procedure( ID       : Byte;
                               Material : Byte;
                               Color    : Integer;
                               Alpha    : Integer = 255 ); stdcall;

Light_SetExponent : procedure( ID : Byte; Value : Single ); stdcall;

const
  A_CONSTANT  = 1;
  A_LINEAR    = 2;
  A_QUADRATIC = 3;
var
Light_SetAttenuation : procedure( ID, AType : Byte; Value : Single ); stdcall;

{------------------------------------------------------------------------------}
{------------------------------  S H A D E R S  -------------------------------}
{------------------------------------------------------------------------------}
//     -  OpenGL.pas :)   
//   

Shader_InitGLSL : function : Boolean; stdcall;

const
  SHADER_VERTEX   = $8B31;
  SHADER_FRAGMENT = $8B30;
var
Shader_LoadFromFile : function( FileName   : PChar;
                                ShaderType : Integer;
                                Link       : Boolean = TRUE ) : DWORD; stdcall;

Shader_Attach : procedure( Attach : DWORD ); stdcall;

Shader_BeginLink : procedure; stdcall;
Shader_EndLink : function : DWORD; stdcall;

Shader_Begin : procedure( Shader : DWORD ); stdcall;
Shader_End : procedure; stdcall;

Shader_Free : procedure( Shader : DWORD ); stdcall;

Shader_GetUniform : function( Shader : DWORD; UniformName : PChar ) : Integer; stdcall;
Shader_SetUniform1f : procedure( Uniform : Integer; v1 : Single ); stdcall;
Shader_SetUniform1i : procedure( Uniform : Integer; v1 : Integer ); stdcall;
Shader_SetUniform2f : procedure( Uniform : Integer; v1, v2 : Single ); stdcall;
Shader_SetUniform3f : procedure( Uniform : Integer; v1, v2, v3 : Single ); stdcall;
Shader_SetUniform4f : procedure( Uniform : Integer; v1, v2, v3, v4 : Single ); stdcall;

Shader_GetAttrib : function( Shader : DWORD; AttribName : PChar ) : Integer; stdcall;
Shader_SetAttrib1f : procedure( Attrib : Integer; v1 : Single ); stdcall;
Shader_SetAttrib2f : procedure( Attrib : Integer; v1, v2 : Single ); stdcall;
Shader_SetAttrib3f : procedure( Attrib : Integer; v1, v2, v3 : Single ); stdcall;
Shader_SetAttrib4f : procedure( Attrib : Integer; v1, v2, v3, v4 : Single ); stdcall;

{------------------------------------------------------------------------------}
{------------------------------  S H A D O W S  -------------------------------}
{------------------------------------------------------------------------------}

const
  idLIGHT_1 = $000001;
  idLIGHT_2 = $000002;
  idLIGHT_3 = $000004;
  idLIGHT_4 = $000008;
  idLIGHT_5 = $000010;
  idLIGHT_6 = $000020;
  idLIGHT_7 = $000040;
  idLIGHT_8 = $000080;

var
// SHADOWS TO PLANE
Shadow_ToPlane : procedure( Lights    : Integer;
                            DrawPlane : Pointer;
                            DrawScene : Pointer;
                            Matrix    : PMatrix4f ); stdcall;

{------------------------------------------------------------------------------}
{---------------------------  P R O J E C T I O N  ----------------------------}
{------------------------------------------------------------------------------}

Projection_Begin : procedure( Projector : PCamera3D ); stdcall;
Projection_End : procedure; stdcall;

{------------------------------------------------------------------------------}
{------------------------  P R I M I T I V E S  3 D  --------------------------}
{------------------------------------------------------------------------------}

Pr3D_Axes : procedure( Size : Single ); stdcall;
Pr3D_AxesEx : procedure( Size : Single; X, Y, Z : Boolean ); stdcall;

Pr3D_Point : procedure( X, Y, Z : Single ); stdcall;
Pr3D_Line : procedure( X1, Y1, Z1, X2, Y2, Z2 : Single ); stdcall;
Pr3D_Plane : procedure( Width, Height : Single ); stdcall;
Pr3D_Cube : procedure( Width, Height, ZDepth : Single ); stdcall;
Pr3D_Sphere : procedure( Radius : Single; N : Integer ); stdcall;
Pr3D_Pyramid : procedure( Width, Height, ZDepth : Single ); stdcall;

{------------------------------------------------------------------------------}
{----------------------------  B I L L B O A R D S  ---------------------------}
{------------------------------------------------------------------------------}

BillBoards_Begin : procedure; stdcall;
BillBoards_End : procedure; stdcall;

SBillBoard_Draw : procedure( X, Y, Z, sX, sY, sZ : Single ); stdcall;
ABillBoard_Draw : procedure( X, Y, Z, sX, sY, sZ : Single; Frame : Integer ); stdcall;

{------------------------------------------------------------------------------}
{---------------------------------  S K Y  3 D  -------------------------------}
{------------------------------------------------------------------------------}

// SKY BOX
SkyBox_Create : procedure( Back, Front, Top, Bottom, Left, Right : PTexture ); stdcall;

SkyBox_Draw : procedure; stdcall;

// SKY SPHERE
SkySphere_Create : procedure( Texture : PTexture; Quality : Integer ); stdcall;

SkySphere_Draw : procedure; stdcall;

{------------------------------------------------------------------------------}
{--------------------------------  T E X T  3 D  ------------------------------}
{------------------------------------------------------------------------------}

Text3D_Create : function( FontName : PChar; Russian : Boolean ) : DWORD; stdcall;

Text3D_Free : procedure( Font : DWORD ); stdcall;

Text3D_Draw : procedure( Font : DWORD; Text : PChar ); stdcall;

{------------------------------------------------------------------------------}
{------------------------------  M E S H E S  3 D  ----------------------------}
{------------------------------------------------------------------------------}

type
  TFace = record
    Vert : array[ 0..2 ] of WORD;
    Tex  : array[ 0..2 ] of WORD;
end;

type
  TGroup = record
    FaceCount : Integer;
    Faces     : array of TFace;
end;

// STATIC
type
  PStaticMesh = ^TStaticMesh;
  TStaticMesh = record
    Flags         : Integer;

    GroupCount    : Integer;
    VertCount     : Integer;
    TexCoordCount : Integer;

    Vertices  : array of TVertex3D;
    Normals   : array of TVertex3D;
    TexCoords : array of TVertex2D;

    Groups    : array of TGroup;
end;

var
SMesh_LoadFromFile : procedure( FileName : PChar;
                                var Mesh : PStaticMesh ); stdcall;
SMesh_Free : procedure( var Mesh : PStaticMesh ); stdcall;

SMesh_Draw : procedure( Mesh : PStaticMesh ); stdcall;
SMesh_DrawGroup : procedure( Mesh  : PStaticMesh;
                             Group : Integer ); stdcall;

SMesh_DrawFrustum : procedure( Mesh    : PStaticMesh;
                               Frustum : PFrustum ); stdcall;
SMesh_DrawGroupFrustum : procedure( Mesh    : PStaticMesh;
                                    Group   : Integer;
                                    Frustum : PFrustum ); stdcall;

SMesh_GetBox : function( Mesh : PStaticMesh ) : TVertex3D; stdcall;

// FRAME-BY-FRAME ANIMATED
type
  PFFAnimMesh = ^TFFAnimMesh;
  TFFAnimMesh = record
    Flags         : Integer;

    FrameCount    : Integer;
    GroupCount    : Integer;
    VertCount     : Integer;
    TexCoordCount : Integer;

    Vertices  : array of array of TVertex3D;
    Normals   : array of array of TVertex3D;
    TexCoords : array of TVertex2D;

    Groups    : array of TGroup;
end;

var
FFAMesh_LoadFromFile : procedure( FileName : PChar;
                                  var Mesh : PFFAnimMesh ); stdcall;
FFAMesh_Free : procedure( var Mesh : PFFAnimMesh ); stdcall;

FFAMesh_Draw : procedure( Mesh  : PFFAnimMesh;
                          Frame : Integer ); stdcall;
FFAMesh_DrawSmooth : procedure( Mesh   : PFFAnimMesh;
                                Frame  : Integer;
                                Smooth : Single ); stdcall;

FFAMesh_DrawGroup : procedure( Mesh  : PFFAnimMesh;
                               Group : Integer;
                               Frame : Integer ); stdcall;
FFAMesh_DrawGroupSmooth : procedure( Mesh   : PFFAnimMesh;
                                     Group  : Integer;
                                     Frame  : Integer;
                                     Smooth : Single ); stdcall;

FFAMesh_GetBox : function( Mesh : PFFAnimMesh ) : TVertex3D; stdcall;

//----------------------------------------------------------------------------//
//---------------------------  D R A W  L I S T  -----------------------------//
//----------------------------------------------------------------------------//
DrawList_Begin : function : DWORD; stdcall;

DrawList_End : procedure; stdcall;

DrawList_Free : procedure( List : DWORD ); stdcall;

DrawList_Draw : procedure( List : DWORD ); stdcall;

{------------------------------------------------------------------------------}
{----------------------------------  V B O  -----------------------------------}
{------------------------------------------------------------------------------}

type
  PVBO = ^TVBO;
  TVBO = record
    UseVBO      : Boolean;
    IndexBuffer : DWORD;
    VertBuffer  : DWORD;

    VertCount     : Integer;
    IndexCount    : Integer;

    UseNormals : Boolean;
    UseTexture : Boolean;
    TexLayers  : Integer;    
    
    Vertices  : array of TVertex3D;
    Normals   : array of TVertex3D;
    TexCoords : array of TVertex2D;
    Indexes   : array of Integer;
  end;

var
VBO_Get : function : PVBO; stdcall;

VBO_AddVertex : procedure( VBO : PVBO; Vertex : TVertex3D ); stdcall;

VBO_AddNormal : procedure( VBO : PVBO; Normal : TVertex3D; ID : Integer ); stdcall;

VBO_AddTexCoord : procedure( VBO : PVBO; TexCoord : TVertex2D; ID : Integer ); stdcall;

VBO_AddIndex : procedure( VBO : PVBO; Index : Integer ); stdcall;

VBO_Create : procedure( VBO : PVBO; FreeData : Boolean ); stdcall;

VBO_Free : procedure( VBO : PVBO; FullFree : Boolean ); stdcall;

VBO_Draw : procedure( VBO : PVBO ); stdcall;

{------------------------------------------------------------------------------}
{------------------------------  F R U S T U M  -------------------------------}
{------------------------------------------------------------------------------}

Frustum_Calc : procedure( f : PFrustum ); stdcall;

Frustum_PointIn : function( f : PFrustum; x, y, z : Single ) : Boolean; stdcall;

Frustum_VertexIn : function( f : PFrustum; Vertex : PVertex3D ) : Boolean; stdcall;

Frustum_TriangleIn : function( f : PFrustum; v1, v2, v3 : PVertex3D ) : Boolean; stdcall;

Frustum_SphereIn : function( f : PFrustum; x, y, z, r : Single ) : Boolean; stdcall;

Frustum_BoxIn : function( f : PFrustum; x, y, z, bx, by, bz : Single ) : Boolean; stdcall;

{------------------------------------------------------------------------------}
{---------------------------------  M A T H  3 D  -----------------------------}
{------------------------------------------------------------------------------}
// VECTORS
Vector_Get : function( X, Y, Z : Single ) : TVertex3D;

Vector_Add : function( Vector1, Vector2 : TVertex3D ) : TVertex3D;
Vector_Sub : function( Vector1, Vector2 : TVertex3D ) : TVertex3D;
Vector_Mul : function( Vector1, Vector2 : TVertex3D ) : TVertex3D;
Vector_Div : function( Vector1, Vectro2 : TVertex3D ) : TVertex3D;

Vector_AddV : function( Vector : TVertex3D; Value : Single ) : TVertex3D;
Vector_SubV : function( Vector : TVertex3D; Value : Single ) : TVertex3D;
Vector_MulV : function( Vector : TVertex3D; Value : Single ) : TVertex3D;
Vector_DivV : function( Vector : TVertex3D; Value : Single ) : TVertex3D;

Vector_Normalize : function( Vector : TVertex3D ): TVertex3D;
Vector_Cross     : function( Vector1, Vector2 : TVertex3D ) : TVertex3D;

//----------------------------------------------------------------------------//
                                 IMPLEMENTATION
//----------------------------------------------------------------------------//

function MessageBoxA(hWnd: DWORD; lpText, lpCaption: PChar; uType: DWORD): Integer; stdcall; external 'user32.dll';
function LoadLibraryA(lpLibFileName: PAnsiChar): HMODULE; stdcall; external 'kernel32.dll';
function FreeLibrary(hLibModule: HMODULE): Boolean; stdcall; external 'kernel32.dll';
function GetProcAddress(hModule: HMODULE; lpProcName: PAnsiChar): Pointer; stdcall; external 'kernel32.dll';

procedure LoadOMEGA3D;
Begin
LibOmega3D := LoadLibraryA( PChar( FileName ) );

if LibOmega3D <> 0 Then
  begin
    @OE3D_Init               := GetProcAddress( LibOmega3d, 'OE3D_Init' );
    @Set2DMode               := GetProcAddress( LibOmega3d, 'Set2DMode' );
    @Set3DMode               := GetProcAddress( LibOmega3d, 'Set3DMode' );
    @ZBuffer_Clear           := GetProcAddress( LibOmega3d, 'ZBuffer_Clear' );
    @ZBuffer_SetDepth        := GetProcAddress( LibOmega3d, 'ZBuffer_SetDepth' );
    @ZBuffer_SetActive       := GetProcAddress( LibOmega3d, 'ZBuffer_SetActive' );
    @Obj_Begin               := GetProcAddress( LibOmega3d, 'Obj_Begin' );
    @Obj_End                 := GetProcAddress( LibOmega3d, 'Obj_End' );
    @Obj_Enable              := GetProcAddress( LibOmega3d, 'Obj_Enable' );
    @Obj_Disable             := GetProcAddress( LibOmega3d, 'Obj_Disable' );
    @Obj_SetCullFaceMode     := GetProcAddress( LibOmega3d, 'Obj_SetCullFaceMode' );
    @Obj_SetShadeMode        := GetProcAddress( LibOmega3d, 'Obj_SetShadeMode' );
    @Obj_SetWireFrameMode    := GetProcAddress( LibOmega3d, 'Obj_SetWireFrameMode' );
    @Obj_PushMatrix          := GetProcAddress( LibOmega3d, 'Obj_PushMatrix' );
    @Obj_PopMatrix           := GetProcAddress( LibOmega3d, 'Obj_PopMatrix' );
    @Obj_ClearMatrix         := GetProcAddress( LibOmega3d, 'Obj_ClearMatrix' );
    @Obj_Move                := GetProcAddress( LibOmega3d, 'Obj_Move' );
    @Obj_Move2D              := GetProcAddress( LibOmega3d, 'Obj_Move2D' );
    @Obj_RotateX             := GetProcAddress( LibOmega3d, 'Obj_RotateX' );
    @Obj_RotateY             := GetProcAddress( LibOmega3d, 'Obj_RotateY' );
    @Obj_RotateZ             := GetProcAddress( LibOmega3d, 'Obj_RotateZ' );
    @Obj_Scale               := GetProcAddress( LibOmega3d, 'Obj_Scale' );
    @Obj_Get3D               := GetProcAddress( LibOmega3d, 'Obj_Get3D' );
    @Obj_Get2D               := GetProcAddress( LibOmega3d, 'Obj_Get2D' );
    @Obj_SetColor            := GetProcAddress( LibOmega3d, 'Obj_SetColor' );
    @Obj_SetMaterial         := GetProcAddress( LibOmega3d, 'Obj_SetMaterial' );
    @Obj_ResetMaterial       := GetProcAddress( LibOmega3d, 'Obj_ResetMaterial' );
    @Obj_BindTexture         := GetProcAddress( LibOmega3d, 'Obj_BindTexture' );
    @Obj_BindMTexture        := GetProcAddress( LibOmega3d, 'Obj_BindMTexture' );
    @Fog_Enable              := GetProcAddress( LibOmega3d, 'Fog_Enable' );
    @Fog_Disable             := GetProcAddress( LibOmega3d, 'Fog_Disable' );
    @Fog_SetMode             := GetProcAddress( LibOmega3d, 'Fog_SetMode' );
    @Fog_SetColor            := GetProcAddress( LibOmega3d, 'Fog_SetColor' );
    @Fog_SetDensity          := GetProcAddress( LibOmega3d, 'Fog_SetDensity' );
    @Fog_SetBeginEnd         := GetProcAddress( LibOmega3d, 'Fog_SetBeginEnd' );
    @Light_Enable            := GetProcAddress( LibOmega3d, 'Light_Enable' );
    @Light_Disable           := GetProcAddress( LibOmega3d, 'Light_Disable' );
    @Light_GetMaxID          := GetProcAddress( LibOmega3d, 'Light_GetMaxID' );
    @Light_SetPosition       := GetProcAddress( LibOmega3d, 'Light_SetPosition' );
    @Light_SetMaterial       := GetProcAddress( LibOmega3d, 'Light_SetMaterial' );
    @Light_SetExponent       := GetProcAddress( LibOmega3d, 'Light_SetExponent' );
    @Light_SetAttenuation    := GetProcAddress( LibOmega3d, 'Light_SetAttenuation' );
    @Shadow_ToPlane          := GetProcAddress( LibOmega3d, 'Shadow_ToPlane' );
    @Projection_Begin        := GetProcAddress( LibOmega3d, 'Projection_Begin' );
    @Projection_End          := GetProcAddress( LibOmega3d, 'Projection_End' );
    @Shader_InitGLSL         := GetProcAddress( LibOmega3d, 'Shader_InitGLSL' );
    @Shader_LoadFromFile     := GetProcAddress( LibOmega3d, 'Shader_LoadFromFile' );
    @Shader_Attach           := GetProcAddress( LibOmega3d, 'Shader_Attach' );
    @Shader_BeginLink        := GetProcAddress( LibOmega3d, 'Shader_BeginLink' );
    @Shader_EndLink          := GetProcAddress( LibOmega3d, 'Shader_EndLink' );
    @Shader_Begin            := GetProcAddress( LibOmega3d, 'Shader_Begin' );
    @Shader_End              := GetProcAddress( LibOmega3d, 'Shader_End' );
    @Shader_Free             := GetProcAddress( LibOmega3d, 'Shader_Free' );
    @Shader_GetUniform       := GetProcAddress( LibOmega3d, 'Shader_GetUniform' );
    @Shader_SetUniform1f     := GetProcAddress( LibOmega3d, 'Shader_SetUniform1f' );
    @Shader_SetUniform1i     := GetProcAddress( LibOmega3d, 'Shader_SetUniform1i' );
    @Shader_SetUniform2f     := GetProcAddress( LibOmega3d, 'Shader_SetUniform2f' );
    @Shader_SetUniform3f     := GetProcAddress( LibOmega3d, 'Shader_SetUniform3f' );
    @Shader_SetUniform4f     := GetProcAddress( LibOmega3d, 'Shader_SetUniform4f' );
    @Shader_GetAttrib        := GetProcAddress( LibOmega3d, 'Shader_GetAttrib' );
    @Shader_SetAttrib1f      := GetProcAddress( LibOmega3d, 'Shader_SetAttrib1f' );
    @Shader_SetAttrib2f      := GetProcAddress( LibOmega3d, 'Shader_SetAttrib2f' );
    @Shader_SetAttrib3f      := GetProcAddress( LibOmega3d, 'Shader_SetAttrib3f' );
    @Shader_SetAttrib4f      := GetProcAddress( LibOmega3d, 'Shader_SetAttrib4f' );
    @Pr3D_Axes               := GetProcAddress( LibOmega3d, 'Pr3D_Axes' );
    @Pr3D_AxesEx             := GetProcAddress( LibOmega3d, 'Pr3D_AxesEx' );
    @Pr3D_Point              := GetProcAddress( LibOmega3d, 'Pr3D_Point' );
    @Pr3D_Line               := GetProcAddress( LibOmega3d, 'Pr3D_Line' );
    @Pr3D_Plane              := GetProcAddress( LibOmega3d, 'Pr3D_Plane' );
    @Pr3D_Cube               := GetProcAddress( LibOmega3d, 'Pr3D_Cube' );
    @Pr3D_Sphere             := GetProcAddress( LibOmega3d, 'Pr3D_Sphere' );
    @Pr3D_Pyramid            := GetProcAddress( LibOmega3d, 'Pr3D_Pyramid' );
    @BillBoards_Begin        := GetProcAddress( LibOmega3d, 'BillBoards_Begin' );
    @BillBoards_End          := GetProcAddress( LibOmega3d, 'BillBoards_End' );
    @SBillBoard_Draw         := GetProcAddress( LibOmega3d, 'SBillBoard_Draw' );
    @ABillBoard_Draw         := GetProcAddress( LibOmega3d, 'ABillBoard_Draw' );
    @SkyBox_Create           := GetProcAddress( LibOmega3d, 'SkyBox_Create' );
    @SkyBox_Draw             := GetProcAddress( LibOmega3d, 'SkyBox_Draw' );
    @SkySphere_Create        := GetProcAddress( LibOmega3d, 'SkySphere_Create' );
    @SkySphere_Draw          := GetProcAddress( LibOmega3d, 'SkySphere_Draw' );
    @Text3D_Create           := GetProcAddress( LibOmega3d, 'Text3D_Create' );
    @Text3D_Free             := GetProcAddress( LibOmega3d, 'Text3D_Free' );
    @Text3D_Draw             := GetProcAddress( LibOmega3d, 'Text3D_Draw' );
    @SMesh_LoadFromFile      := GetProcAddress( LibOmega3d, 'SMesh_LoadFromFile' );
    @SMesh_Free              := GetProcAddress( LibOmega3d, 'SMesh_Free' );
    @SMesh_Draw              := GetProcAddress( LibOmega3d, 'SMesh_Draw' );
    @SMesh_DrawGroup         := GetProcAddress( LibOmega3d, 'SMesh_DrawGroup' );
    @SMesh_DrawFrustum       := GetProcAddress( LibOmega3d, 'SMesh_DrawFrustum' );
    @SMesh_DrawGroupFrustum  := GetProcAddress( LibOmega3d, 'SMesh_DrawGroupFrustum' );
    @SMesh_GetBox            := GetProcAddress( LibOmega3d, 'SMesh_GetBox' );
    @FFAMesh_LoadFromFile    := GetProcAddress( LibOmega3d, 'FFAMesh_LoadFromFile' );
    @FFAMesh_Free            := GetProcAddress( LibOmega3d, 'FFAMesh_Free' );
    @FFAMesh_Draw            := GetProcAddress( LibOmega3d, 'FFAMesh_Draw' );
    @FFAMesh_DrawSmooth      := GetProcAddress( LibOmega3d, 'FFAMesh_DrawSmooth' );
    @FFAMesh_DrawGroup       := GetProcAddress( LibOmega3d, 'FFAMesh_DrawGroup' );
    @FFAMesh_DrawGroupSmooth := GetProcAddress( LibOmega3d, 'FFAMesh_DrawGroupSmooth' );
    @FFAMesh_GetBox          := GetProcAddress( LibOmega3d, 'FFAMesh_GetBox' );
    @DrawList_Begin          := GetProcAddress( LibOmega3d, 'DrawList_Begin' );
    @DrawList_End            := GetProcAddress( LibOmega3d, 'DrawList_End' );
    @DrawList_Free           := GetProcAddress( LibOmega3d, 'DrawList_Free' );
    @DrawList_Draw           := GetProcAddress( LibOmega3d, 'DrawList_Draw' );
    @VBO_Get                 := GetProcAddress( LibOmega3d, 'VBO_Get' );
    @VBO_AddVertex           := GetProcAddress( LibOmega3d, 'VBO_AddVertex' );
    @VBO_AddNormal           := GetProcAddress( LibOmega3d, 'VBO_AddNormal' );
    @VBO_AddTexCoord         := GetProcAddress( LibOmega3d, 'VBO_AddTexCoord' );
    @VBO_AddIndex            := GetProcAddress( LibOmega3d, 'VBO_AddIndex' );
    @VBO_Create              := GetProcAddress( LibOmega3d, 'VBO_Create' );
    @VBO_Free                := GetProcAddress( LibOmega3d, 'VBO_Free' );
    @VBO_Draw                := GetProcAddress( LibOmega3d, 'VBO_Draw' );
    @Cam3D_Create            := GetProcAddress( LibOmega3d, 'Cam3D_Create' );
    @Cam3D_Free              := GetProcAddress( LibOmega3d, 'Cam3D_Free' );
    @Cam3D_Set               := GetProcAddress( LibOmega3d, 'Cam3D_Set' );
    @Cam3D_RotateRad         := GetProcAddress( LibOmega3d, 'Cam3D_RotateRad' );
    @Cam3D_RotateAng         := GetProcAddress( LibOmega3d, 'Cam3D_RotateAng' );
    @Cam3D_Fly               := GetProcAddress( LibOmega3d, 'Cam3D_Fly' );
    @Cam3D_Strafe            := GetProcAddress( LibOmega3d, 'Cam3D_Strafe' );
    @Frustum_Calc            := GetProcAddress( LibOmega3d, 'Frustum_Calc' );
    @Frustum_PointIn         := GetProcAddress( LibOmega3d, 'Frustum_PointIn' );
    @Frustum_VertexIn        := GetProcAddress( LibOmega3d, 'Frustum_VertexIn' );
    @Frustum_TriangleIn      := GetProcAddress( LibOmega3d, 'Frustum_TriangleIn' );
    @Frustum_SphereIn        := GetProcAddress( LibOmega3d, 'Frustum_SphereIn' );
    @Frustum_BoxIn           := GetProcAddress( LibOmega3d, 'Frustum_BoxIn' );
    @Vector_Get              := GetProcAddress( LibOmega3d, 'Vector_Get' );
    @Vector_Add              := GetProcAddress( LibOmega3d, 'Vector_Add' );
    @Vector_Sub              := GetProcAddress( LibOmega3d, 'Vector_Sub' );
    @Vector_Mul              := GetProcAddress( LibOmega3d, 'Vector_Mul' );
    @Vector_Div              := GetProcAddress( LibOmega3d, 'Vector_Div' );
    @Vector_AddV             := GetProcAddress( LibOmega3d, 'Vector_AddV' );
    @Vector_SubV             := GetProcAddress( LibOmega3d, 'Vector_SubV' );
    @Vector_MulV             := GetProcAddress( LibOmega3d, 'Vector_MulV' );
    @Vector_DivV             := GetProcAddress( LibOmega3d, 'Vector_DivV' );
    @Vector_Normalize        := GetProcAddress( LibOmega3d, 'Vector_Normalize' );
    @Vector_Cross            := GetProcAddress( LibOmega3d, 'Vector_Cross' );
  end else
    MessageBoxA( 0, 'Error while loading OMEGA 3D', 'Error', $00000010 );
End;

procedure FreeOMEGA3D;
Begin
FreeLibrary( LibOmega3D );
End;

end.
